package gov.va.vamf.scheduling.varutility.linkbuilder;

import gov.va.vamf.scheduling.varutility.domain.CoreSetting;
import gov.va.vamf.scheduling.varutility.domain.CoreSettings;
import gov.va.vamf.scheduling.varutility.domain.DirectBookingEligibilityCriteria;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.net.URI;

import static junit.framework.TestCase.assertNotNull;
import static org.junit.Assert.assertEquals;

@ContextConfiguration(locations = { "classpath:applicationContext-test.xml" })
@RunWith(SpringJUnit4ClassRunner.class)
public class LinkBuilderTest {

	DirectBookingEligibilityCriteria criteria;

	@Before
	public void setup() {
		criteria = new DirectBookingEligibilityCriteria();
		CoreSettings cs = new CoreSettings();
		CoreSetting c = new CoreSetting();
		c.setId("323");
		c.setTypeOfCare("Test Primary Care");
		c.setPatientHistoryRequired("yes");
		c.setPatientHistoryDuration(720);
		cs.add(c);
		criteria.setId("1");
		criteria.setCoreSettings(cs);
	}

	@Test
	public void fillLinkTest() {
		URI uri = URI.create("http://test/");
		LinkBuilder.fillLink(criteria, uri);

		assertNotNull(uri);
	}
}
